import React from 'react'

import { Avatar, ListItem, ListItemAvatar, ListItemText } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  label: string
  icon: JSX.Element
  onClick?: () => void
}

const GridItem = (props: Props) => {
  const { classes, icon, label, onClick } = props
  return (
    <ListItem button onClick={onClick} className={classes.listItem}>
      <ListItemAvatar>
        <Avatar className={classes.avatar}>{icon}</Avatar>
      </ListItemAvatar>
      <ListItemText primary={label} />
    </ListItem>

    // <Grid item xl={4} className={classes.gridItem}>
    //   <DashboardCard label={label} icon={icon} onClick={onClick} />
    // </Grid>
  )
}

export default withStyles(styles)(GridItem)
