import React, { ChangeEvent, useState } from 'react'

import { Tab } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'
import {
  AccountBox as AccountBoxIcon,
  CheckBox as CheckBoxIcon,
  ContactMail as ContactMailIcon,
  Forum as ForumIcon,
  Home as HomeIcon,
  List as ListIcon,
  LocalAtm as LocalAtmIcon,
  ZoomOutMap as ZoomOutMapIcon
} from '@material-ui/icons'
import { TabContext, TabList, TabPanel } from '@material-ui/lab'

import Identification from './Identification'
import styles from './styles'

export const involvedPeopleItems = [
  { label: 'Identificação', icon: <AccountBoxIcon />, component: <Identification /> },
  { label: 'Dados Pessoais', icon: <ListIcon />, component: <div>Dados Pessoais</div> },
  { label: 'Endereço', icon: <ContactMailIcon />, component: <div>Endereço</div> },
  { label: 'Fonte de renda', icon: <LocalAtmIcon />, component: <div>Fonte de renda</div> },
  { label: 'Cônjuge - Ident.', icon: <ForumIcon />, component: <div>Cônjuge - Ident.</div> },
  { label: 'Cônjuge +', icon: <ZoomOutMapIcon />, component: <div>Cônjuge +</div> },
  { label: 'Referências', icon: <CheckBoxIcon />, component: <div>Referências</div> },
  { label: 'Moradia', icon: <HomeIcon />, component: <div>Moradia</div> },
]

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {}

const InvolvedPeople = (props: Props) => {
  const { classes } = props
  const [tab, setTab] = useState('0')

  const handleChange = (evt: ChangeEvent<Record<string, unknown>>, newValue: number) => {
    setTab(newValue.toString())
  }

  return (
    <div className={classes.contentContainer}>
      <TabContext value={tab}>
        <TabList
          orientation="vertical"
          variant="scrollable"
          value={tab}
          onChange={handleChange}
          aria-label="Vertical tabs example"
          className={classes.tabs}
        >
          {involvedPeopleItems.map(({ component, ...tb }, i) => (
            <Tab wrapped key={i} {...tb} value={i.toString()} />
          ))}
        </TabList>
        <div className={classes.content}>
          {involvedPeopleItems.map((tb, i) => (
            <TabPanel key={i} value={i.toString()}>
              {tb.component}
            </TabPanel>
          ))}
        </div>
      </TabContext>
    </div>
  )
}

export default withStyles(styles)(InvolvedPeople)
