import React from 'react'

import { InvolvedPersonType } from '@agiliza/api/domain'
import { Dialog, DialogProps, List, ListItem, ListItemText } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import styles from './styles'

type ExtendedProps = Pick<DialogProps, 'open' | 'onClose'> & WithStyles<typeof styles>

interface Props extends ExtendedProps {
  onSelectType(type: InvolvedPersonType): () => void
}

const SelectTypeDialog = (props: Props) => {
  const { classes, open, onClose, onSelectType } = props
  return (
    <Dialog onClose={onClose} aria-labelledby="simple-dialog-title" open={open} PaperProps={{ className: classes.dialog }}>
      <List>
        <ListItem button onClick={onSelectType('CUSTOMER')}>
          <ListItemText primary="Cliente" className={classes.listItemText} />
        </ListItem>
        <ListItem button onClick={onSelectType('GUARANTOR')}>
          <ListItemText primary="Avalista" className={classes.listItemText} />
        </ListItem>
        <ListItem button>
          <ListItemText primary="Sócio" onClick={onSelectType('PARTNER')} className={classes.listItemText} />
        </ListItem>
      </List>
    </Dialog>
  )
}

export default withStyles(styles)(SelectTypeDialog)
