import { file } from '@agiliza/__mocks__/files'
import { Vehicle } from '@agiliza/api/domain'

type ExtendedState = Vehicle

export interface CDVehicleState extends ExtendedState {}

export const initialState: CDVehicleState =
  process.env.NODE_ENV === 'development'
    ? {
        id: '',
        brand: 'TEST',
        document: file,
        hasInsurance: true,
        hasOnus: true,
        licensePlate: 'AAA9999',
        marketValue: '25000',
        model: 'TEST',
        year: '2010',
      }
    : {
        id: '',
        brand: '',
        document: '',
        hasInsurance: false,
        hasOnus: false,
        licensePlate: '',
        marketValue: '',
        model: '',
        year: '',
      }
