import { file } from '@agiliza/__mocks__/files'
import { SpousePersonalData } from '@agiliza/api/domain'

type ExtendedState = SpousePersonalData

export interface CDSpousePersonalDataState extends ExtendedState {}

export const initialState: CDSpousePersonalDataState =
  process.env.NODE_ENV === 'development'
    ? {
        cpf: '94054291082',
        name: 'TEST',
        rg: { number: '1234', dispatcherAgency: '123', front: file, back: file },
        birthday: new Date('1990-10-10'),
        userCRAS: false,
        mothersName: 'TEST',
        fathersName: 'TEST',
        occupation: 'TEST',
        schooling: '1',
        maritalStatus: '1',
        dependents: '0',
        participationPercentage: '20',
        marriageCertificate: file,
        landline: '2733410125',
        mobile: '27998787452',
        primaryEmail: 'test@email.com',
        secundaryEmail: 'test@email.com',
        workplace: {
          // address: { cep: '', city: '', complement: '', district: '', number: '', state: '', street: '' },
          cnpj: '59355240000151',
          workplaceName: 'TEST',
          admissionDate: new Date('2000-10-10'),
          netIncome: '2500',
          phone: '27998545787',
          proof: file,
          role: 'TEST',
        },
      }
    : {
        cpf: '',
        name: '',
        rg: { number: '', dispatcherAgency: '', front: '', back: '' },
        birthday: null,
        userCRAS: false,
        mothersName: '',
        fathersName: '',
        occupation: '',
        schooling: '',
        maritalStatus: '',
        dependents: '',
        participationPercentage: '',
        marriageCertificate: '',
        landline: '',
        mobile: '',
        primaryEmail: '',
        secundaryEmail: '',
        workplace: {
          // address: { cep: '', city: '', complement: '', district: '', number: '', state: '', street: '' },
          workplaceName: '',
          admissionDate: null,
          netIncome: '',
          phone: '',
          proof: '',
          role: '',
        },
      }
