import React from 'react'

import { ActionType } from '@agiliza/utils/hooks/state'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import { connected, ConnectedProps } from './connect'
import Form from './Form'
import { CDSpousePersonalDataState } from './state'
import styles from './styles'

type ExtendedProps = WithStyles<typeof styles> & ConnectedProps

interface Props extends ExtendedProps {
  state: CDSpousePersonalDataState
  actions: ActionType<CDSpousePersonalDataState>
}

const SpouseData = (props: Props) => {
  const { classes, context, state, actions } = props

  return (
    <div className={classes.contentContainer}>
      <div className={classes.content}>
        <Form state={state} actions={actions} context={context} />
      </div>
    </div>
  )
}

export default connected(withStyles(styles)(SpouseData))
