import { file } from '@agiliza/__mocks__/files'
import { PersonalData } from '@agiliza/api/domain'

type ExtendedState = PersonalData

export interface CDPersonalDataState extends ExtendedState {}

export const initialState: CDPersonalDataState =
  process.env.NODE_ENV === 'development'
    ? {
        rg: { number: '1234', dispatcherAgency: '1233', front: file, back: file },
        birthday: new Date('1985-10-10'),
        userCRAS: false,
        mothersName: 'TEST',
        fathersName: 'TEST',
        occupation: 'TEST',
        schooling: '1',
        maritalStatus: '1',
        dependents: '0',
        primaryEmail: 'test@email.com',
        secundaryEmail: 'test@email.com',
        mobile: '27998787541',
        landline: '2733414145',
      }
    : {
        rg: { number: '', dispatcherAgency: '', front: '', back: '' },
        birthday: null,
        userCRAS: false,
        mothersName: '',
        fathersName: '',
        occupation: '',
        schooling: '',
        maritalStatus: '',
        dependents: '',
        primaryEmail: '',
        secundaryEmail: '',
        mobile: '',
        landline: '',
      }
