import React from 'react'

import { ActionType } from '@agiliza/utils/hooks/state'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import { connected, ConnectedProps } from './connect'
import Form from './Form'
import { CDAddressState } from './state'
import styles from './styles'

type ExtendedProps = WithStyles<typeof styles> & ConnectedProps

interface Props extends ExtendedProps {
  state: CDAddressState
  actions: ActionType<CDAddressState>
}

const Address = (props: Props) => {
  const { classes, context, state, actions } = props

  return (
    <div className={classes.contentContainer}>
      <div className={classes.content}>
        <Form states={context.states} cities={context.cities} state={state} actions={actions} />
      </div>
    </div>
  )
}

export default connected(withStyles(styles)(Address))
