import { Theme } from '@material-ui/core/styles'
import { createStyles } from '@material-ui/styles'

import sharedStyles from '../shared-styles'

// eslint-disable-next-line
export default (theme: Theme) =>
  createStyles({
    ...sharedStyles(theme),
    cardsContainer: { display: 'flex' },
    gridItem: { display: 'flex', justifyContent: 'center' },
    tabsContainer: { display: 'flex', width: '100%', flex: 10 },
    tabs: { borderRight: `1px solid ${theme.palette.divider}` },
    tabWrapper: { flexDirection: 'row' },
    tabLabelIcon: { marginBottom: '0px !important', marginRight: theme.spacing(1) },
    label: { marginBottom: theme.spacing(2) },
  })
