import { connect } from 'react-redux'

import { AuthenticationContext } from '@agiliza/api/domain'
import { StoreState } from '@agiliza/redux'
import * as entAuthentication from '@agiliza/redux/entities/authentication'

export interface ConnectedProps {
  context: AuthenticationContext
}

type StateProps = Pick<ConnectedProps, 'context'>
// type DispatchProps = Pick<ConnectedProps, 'getContext'>

const mapStateToProps = (state: StoreState): StateProps => ({
  context: entAuthentication.selectors.getContextEntities(state.entities.authentication),
})

// const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
//   bindActionCreators(
//     {
//     },
//     dispatch
//   )

export const connected = connect(mapStateToProps)
