import { createStyles, Theme } from '@material-ui/core/styles'

import sharedStyles from '../shared-styles'

export default (theme: Theme) => {
  return createStyles({
    ...sharedStyles(theme),
    pageContainer: {
      height: '100vh',
      display: 'flex',
      flexDirection: 'column',
      // padding: theme.spacing(2),
      paddingTop: 0,
      paddingBottom: 0,
      justifyContent: 'flex-start',
    },
    appTitle: { flexGrow: 1, fontSize: '100%', textTransform: 'uppercase' },
    titleAnchor: { cursor: 'pointer' },
  })
}
