import { connect } from 'react-redux'
import { bindActionCreators, Dispatch } from 'redux'

import { StoreState } from '@agiliza/redux'
import { actions as drawerActions } from '@agiliza/redux/ui/drawer'
import { isDrawerOpen } from '@agiliza/redux/ui/drawer/selectors'
import { actions as loginActions } from '@agiliza/redux/ui/login'
import { actions as systemActions, selectors as systemSelectors } from '@agiliza/redux/ui/system'

export interface ConnectedProps {
  drawerOpen: boolean
  fetchingMenu: boolean
  fetchMenu: typeof systemActions.fetchMenu
  toggleDrawer: typeof drawerActions.toggleDrawer
  logout: typeof loginActions.logout
}

const mapStateToProps = (state: StoreState) => ({
  drawerOpen: isDrawerOpen(state.ui.drawer),
  fetchMenu: systemActions.fetchMenu,
  fetchingMenu: systemSelectors.isFetching(state.ui.system),
})

const mapDispatchToProps = (dispatch: Dispatch) =>
  bindActionCreators(
    {
      toggleDrawer: drawerActions.toggleDrawer,
      logout: loginActions.logout,
      fetchMenu: systemActions.fetchMenu,
    },
    dispatch
  )

export default connect(mapStateToProps, mapDispatchToProps)
