import {
  AddBDProductService,
  GetBDProductsServices,
  UpdateBDAddress,
  UpdateBDIdentification,
  UpdateBDProductService,
  UpdateBDStockSalesCosts
} from '@agiliza/api/domain'
import { PDBusinessDataRepositoryImplFactory } from '@agiliza/api/useCases'
import { appPlatform } from '@agiliza/constants/platform'
import {
  createAsyncReducers,
  getTypesThunkActions,
  values,
  WithSuccess
} from '@agiliza/utils/method'
import { createAsyncThunk, createSlice } from '@reduxjs/toolkit'

const prefix = 'useCases/businessData'

export interface State {
  fetching: boolean
}

export const initialState: State = {
  fetching: false,
}

export const actions = {
  getProductsServices: createAsyncThunk(`${prefix}/getProductsServices`, async (input: WithSuccess<GetBDProductsServices['Input']>, thunkApi) => {
    const useCase = PDBusinessDataRepositoryImplFactory.create(appPlatform)
    try {
      const response = await useCase.getProductsServices(input)
      input.onSuccess && input.onSuccess()
      return response
    } catch (e) {
      return thunkApi.rejectWithValue(e)
    }
  }),
  addProductService: createAsyncThunk(`${prefix}/addProductService`, async (input: WithSuccess<AddBDProductService['Input']>, thunkApi) => {
    const useCase = PDBusinessDataRepositoryImplFactory.create(appPlatform)
    try {
      const response = await useCase.addProductService(input)
      input.onSuccess && input.onSuccess()
      return response
    } catch (e) {
      return thunkApi.rejectWithValue(e)
    }
  }),
  updateProductService: createAsyncThunk(`${prefix}/updateProductService`, async (input: WithSuccess<UpdateBDProductService['Input']>, thunkApi) => {
    const useCase = PDBusinessDataRepositoryImplFactory.create(appPlatform)
    try {
      const response = await useCase.updateProductService(input)
      input.onSuccess && input.onSuccess()
      return response
    } catch (e) {
      return thunkApi.rejectWithValue(e)
    }
  }),
  updateIdentification: createAsyncThunk(`${prefix}/updateIdentification`, async (input: WithSuccess<UpdateBDIdentification['Input']>, thunkApi) => {
    const useCase = PDBusinessDataRepositoryImplFactory.create(appPlatform)
    try {
      const response = await useCase.updateIdentification(input)
      input.onSuccess && input.onSuccess()
      return response
    } catch (e) {
      return thunkApi.rejectWithValue(e)
    }
  }),
  updateAddress: createAsyncThunk(`${prefix}/updateAddress`, async (input: WithSuccess<UpdateBDAddress['Input']>, thunkApi) => {
    const useCase = PDBusinessDataRepositoryImplFactory.create(appPlatform)
    try {
      const response = await useCase.updateAddress(input)
      input.onSuccess && input.onSuccess()
      return response
    } catch (e) {
      return thunkApi.rejectWithValue(e)
    }
  }),
  updateStockSalesCosts: createAsyncThunk(
    `${prefix}/updateStockSalesCosts`,
    async (input: WithSuccess<UpdateBDStockSalesCosts['Input']>, thunkApi) => {
      const useCase = PDBusinessDataRepositoryImplFactory.create(appPlatform)
      try {
        const response = await useCase.updateStockSalesCosts(input)
        input.onSuccess && input.onSuccess()
        return response
      } catch (e) {
        return thunkApi.rejectWithValue(e)
      }
    }
  ),
} as const
export const types = getTypesThunkActions(actions)

const login = createSlice({
  name: prefix,
  initialState,
  reducers: {},
  extraReducers: {
    ...values(types).reduce((reducers, type) => ({ ...reducers, ...createAsyncReducers(type) }), {}),
  },
})

export default login
