import authentication, {
  initialState as authenticationInitialState,
  State as AuthenticationState
} from './authentication'
import proposalData, {
  initialState as proposalDataInitialState,
  State as ProposalDataState
} from './proposalData'
import simulation, {
  initialState as simulationInitialState,
  State as SimulationState
} from './simulation'

export interface UseCasesState {
  simulation: SimulationState
  authentication: AuthenticationState
  proposalData: ProposalDataState
}

const reducers = {
  simulation,
  authentication,
  proposalData,
}

export const initialState: UseCasesState = {
  simulation: simulationInitialState,
  authentication: authenticationInitialState,
  proposalData: proposalDataInitialState,
}

export default reducers
