import { normalize, schema } from 'normalizr'

import { SimulationCategory, SubProduct } from '@agiliza/api/domain'
import { NormalizedEntity } from '@agiliza/utils/method'

export const SIMULATION_PREFIX = 'entities/simulation'

export interface NormalizedSimulationCategories {
  simulationCategories: NormalizedEntity<SimulationCategory>
}

export interface NormalizedSubproducts {
  subproducts: NormalizedEntity<SubProduct>
}

const simulationCategory = new schema.Array(new schema.Entity('simulationCategories'))
const subProduct = new schema.Array(new schema.Entity('subproducts'))

export const normalizeSimulationCategories = (sCs: SimulationCategory[]) => {
  const { entities } = normalize(sCs, simulationCategory)
  const normalizedEntities = entities as unknown as NormalizedSimulationCategories
  return normalizedEntities
}

export const normalizeSubproducts = (sPs: SubProduct[]) => {
  const { entities } = normalize(sPs, subProduct)
  const normalizedEntities = entities as unknown as NormalizedSubproducts
  return normalizedEntities
}
