import { combineReducers } from 'redux'

import context, { initialState as contextInitState, Store as ContextStore } from './context'
import simulation, {
  initialState as simulationInitState,
  Store as SimulationStore
} from './simulation'

export interface State {
  context: ContextStore
  simulation: SimulationStore
}
export const initialState: State = {
  context: contextInitState,
  simulation: simulationInitState,
}

export default combineReducers({
  context,
  simulation,
})
