import authentication, {
  initialState as authenticationInitState,
  Store as AuthenticationState
} from './authentication'
import proposalData, {
  initialState as proposalDataInitState,
  State as ProposalDataState
} from './proposalData'
import simulation, {
  initialState as simulationInitState,
  State as SimulationState
} from './simulation'
import { initialState as systemInitState, reducer as system, State as System } from './system'

export interface EntitiesState {
  system: System
  simulation: SimulationState
  authentication: AuthenticationState
  proposalData: ProposalDataState
}

export const initialState: EntitiesState = {
  simulation: simulationInitState,
  system: systemInitState,
  authentication: authenticationInitState,
  proposalData: proposalDataInitState,
}

const reducers = {
  simulation,
  system,
  authentication,
  proposalData,
}

export default reducers
