import React from 'react'

import TextFieldWithIcon from '@agiliza/components/atoms/TextFieldWithIcon'
import { InputAdornment, TextFieldProps } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'
import { AccountCircle } from '@material-ui/icons'

import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  username: string
  password: string
  onChange(type: 'username' | 'password'): TextFieldProps['onChange']
}

const Login = (props: Props) => {
  const { classes, username, password, onChange } = props

  return (
    <form className={classes.form}>
      <TextFieldWithIcon
        autoFocus
        required
        value={username}
        onChange={onChange('username')}
        label="CPF"
        className={classes.usernameTxtField}
        inputProps={{ maxLength: 14 }}
        InputProps={{
          startAdornment: (
            <InputAdornment position="start">
              <AccountCircle />
            </InputAdornment>
          ),
        }}
      />
      <TextFieldWithIcon required value={password} onChange={onChange('password')} label="Senha" type="password" />
    </form>
  )
}

export default withStyles(styles)(Login)
