import React from 'react'

import { Document, ProposalDataContext } from '@agiliza/api/domain'
import ImageUpload from '@agiliza/components/organisms/ImageUpload'
import { SelectField } from '@curio/components'

interface Props {
  onChangeImage: React.DetailedHTMLProps<React.InputHTMLAttributes<HTMLInputElement>, HTMLInputElement>['onChange']
  onChangeDocumentType: (vl: string) => void
  context: ProposalDataContext
  document?: Document
}

const Document = (props: Props) => {
  const { context, document, onChangeDocumentType, onChangeImage } = props

  return (
    <>
      <SelectField
        id="document-type-select-field"
        label="Tipo de documento"
        value={document?.type.id || ''}
        onChange={onChangeDocumentType}
        items={context.documentTypes.map((dT) => ({ label: dT.description, value: dT.id }))}
        variant="outlined"
        shrink={false}
      />
      <ImageUpload label="Foto" image={document?.url || ''} onChangeImage={onChangeImage} />
    </>
  )
}

export default Document
