import cn from 'classnames'
import React from 'react'

import { Button } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'
import { PhotoCamera as PhotoCameraIcon } from '@material-ui/icons'

import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  image?: string
  onChangeImage: React.DetailedHTMLProps<React.InputHTMLAttributes<HTMLInputElement>, HTMLInputElement>['onChange']
  label: string
  imageStyle?: React.HTMLAttributes<HTMLDivElement>['style']
  className?: string
  buttonClassName?: string
}

const ImageUpload = (props: Props) => {
  const { classes, className, buttonClassName, image, onChangeImage, label, imageStyle } = props

  return (
    <div className={cn(className, classes.container)}>
      <Button variant="text" component="label" className={cn(classes.photoBtn, buttonClassName)} classes={{ label: classes.photoLabelBtn }}>
        {image ? (
          <div className={classes.card} style={imageStyle}>
            <img src={'data:image/png;base64,' + image} className={classes.media} />
          </div>
        ) : (
          <PhotoCameraIcon />
        )}
        {label}
        <input
          type="file"
          // value={image}
          accept="image/jpg, image/jpeg, image/png"
          hidden
          onChange={onChangeImage}
        />
      </Button>
    </div>
  )
}

export default withStyles(styles)(ImageUpload)
