import cn from 'classnames'
import React from 'react'

import { makeStyles, Theme } from '@material-ui/core/styles'

const useStyles = makeStyles((theme: Theme) => ({
  card: {
    // backgroundColor: '#fafafa',
    height: 100,
    width: 175,
    padding: theme.spacing(1),
    border: '1px solid #dfdfdf',
    borderRadius: '10px',
    display: 'flex',
    flexDirection: 'column',
    alignItems: 'center',
    justifyContent: 'center',
    // color: theme.palette.grey[500],
    transform: 'scale(1)',
    transition: theme.transitions.create(['color', 'border', 'transform'], {
      duration: theme.transitions.duration.short,
    }),
    '&:hover': {
      transform: 'scale(1.03)',
      color: theme.palette.primary.main,
      borderColor: theme.palette.primary.main,
      cursor: 'pointer',
      border: `1px solid ${theme.palette.primary.main}`,
    },
  },
  cardIcon: {
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
  },
  cardDescription: {
    textAlign: 'center',
  },
}))

export interface DashboardCardProps {
  label: string
  icon: React.ReactNode
  className?: string
  onClick?(): void
}

function DashboardCard(props: DashboardCardProps) {
  const classes = useStyles()
  return (
    <div onClick={props.onClick} className={cn(classes.card, props.className)}>
      <div className={classes.cardIcon}>{props.icon}</div>
      <div className={classes.cardDescription}>{props.label}</div>
    </div>
  )
}

export default DashboardCard
