import { Action } from 'redux'
import { of } from 'rxjs'

import { actions as errorActions } from '@agiliza/redux/ui/error'
import { getError } from '@agiliza/utils/method'

export function mapErrorToActions(response: Error, ...actions: ((error: string) => Action)[]) {
  const error = getError(response)

  return of(...actions.map((a) => a(error)), errorActions.setErrorMessage(error))
}
