import { InstallmentOption, SubProduct } from '@agiliza/api/domain'
import { OpcaoPrestacaoApiModel, SubprodutoApiModel } from '@microcredito/client'

import { DomainAdapter } from '../shared'

export class SubProductMapper implements DomainAdapter<SubprodutoApiModel, SubProduct> {
  public mapInstallmentOption = (opcaoPrestacao: OpcaoPrestacaoApiModel): InstallmentOption => ({
    id: opcaoPrestacao.id || '',
    installmentAmount: opcaoPrestacao.quantidadePrestacoes,
    installmentValue: opcaoPrestacao.valor,
    netValue: opcaoPrestacao.valorLiquido,
  })

  public mapApiModelToDomain = (subproduto: SubprodutoApiModel): SubProduct => ({
    id: subproduto.id || '',
    description: subproduto.descricao,
    IOF: subproduto.iof,
    TAC: subproduto.tac,
    fee: subproduto.taxa,
    installementOptions: subproduto.opcoesPrestacao?.map(this.mapInstallmentOption) || [],
    maxAmountInstallment: subproduto.qntMaxPrestacoes,
  })
}
