import { SimulationCategory } from '@agiliza/api/domain'
import { CategoriaSimulacaoApiModel } from '@microcredito/client'

import { DomainAdapter } from '../shared'

export class SimulationCategoryMapper implements DomainAdapter<CategoriaSimulacaoApiModel, SimulationCategory> {
  public mapApiModelToDomain = (apimodel: CategoriaSimulacaoApiModel): SimulationCategory => {
    return {
      id: apimodel.id || '',
      description: apimodel.descricao || '',
      fullDescription: apimodel.descricaoLonga || '',
      maxInstallment: apimodel.numeroMaximoParcelas,
      maxGraceMonths: apimodel.carenciaMaxima,
    }
  }
}
