import { ProposalDataContext } from '@agiliza/api/domain'
import {
  ClassificacaoMesApiModel,
  EnquadramentoApiModel,
  EscolaridadeApiModel,
  EstadoCivilApiModel,
  GeneroApiModel,
  LocalApiModel,
  OPLiquidadaApiModel,
  RegistroEscrituraApiModel,
  SetorAtividadeApiModel,
  TipoDocumentoApiModel,
  TipoMoradiaApiModel,
  TipoReferenciaApiModel
} from '@microcredito/client'

import { CodeDescriptionMapper, DomainAdapter, IdDescriptionMapper } from '../shared'

export interface DadosPropostaContexto {
  enquadramentos: EnquadramentoApiModel[]
  generos: GeneroApiModel[]
  escolaridades: EscolaridadeApiModel[]
  estadosCivis: EstadoCivilApiModel[]
  tiposReferencia: TipoReferenciaApiModel[]
  registrosEscritura: RegistroEscrituraApiModel[]
  tiposMoradia: TipoMoradiaApiModel[]
  setoresAtividade: SetorAtividadeApiModel[]
  opsLiquidadas: OPLiquidadaApiModel[]
  locais: LocalApiModel[]
  tiposDocumento: TipoDocumentoApiModel[]
  classificacoesMes: ClassificacaoMesApiModel[]
}

export class ContextMapper implements DomainAdapter<DadosPropostaContexto, ProposalDataContext> {
  private idDescriptionMapper: IdDescriptionMapper
  private codeDescriptionMapper: CodeDescriptionMapper

  constructor() {
    this.idDescriptionMapper = new IdDescriptionMapper()
    this.codeDescriptionMapper = new CodeDescriptionMapper()
  }
  public mapApiModelToDomain = (dP: DadosPropostaContexto): ProposalDataContext => ({
    frameworks: dP.enquadramentos.map(this.idDescriptionMapper.mapApiModelToDomain),
    genders: dP.generos.map(this.idDescriptionMapper.mapApiModelToDomain),
    schoolings: dP.escolaridades.map(this.idDescriptionMapper.mapApiModelToDomain),
    maritalStatus: dP.estadosCivis.map(this.idDescriptionMapper.mapApiModelToDomain),
    referenceTypes: dP.tiposReferencia.map(this.idDescriptionMapper.mapApiModelToDomain),
    homeTypes: dP.tiposMoradia.map(this.idDescriptionMapper.mapApiModelToDomain),
    deedRecords: dP.registrosEscritura.map(this.idDescriptionMapper.mapApiModelToDomain),
    activitySectors: dP.setoresAtividade.map(this.idDescriptionMapper.mapApiModelToDomain),
    settledOPs: dP.opsLiquidadas.map(this.idDescriptionMapper.mapApiModelToDomain),
    locals: dP.locais.map(this.idDescriptionMapper.mapApiModelToDomain),
    documentTypes: dP.tiposDocumento.map(this.codeDescriptionMapper.mapApiModelToDomain),
    monthRatings: dP.classificacoesMes.map(this.idDescriptionMapper.mapApiModelToDomain),
  })
}
