import { ApiError, InternalServerError } from '@agiliza/api/domain'
import { ErrorTypes } from '@agiliza/constants/error'

import { DomainAdapter } from './shared'

/** Default response error adapter */
export class ResponseErrorAdapter implements DomainAdapter<Response, Promise<ApiError>> {
  public async mapApiModelToDomain(error: Response): Promise<ApiError> {
    let message: string
    console.log('ERROR', error)
    if (error instanceof Error) {
      console.log(error)
      if (error instanceof TypeError && error.message.includes('Network')) {
        // Network error
        message = 'Ocorreu um problema na conexão ao servidor. Verifique se você está conectado à rede.'
      } else {
        message = error.message
      }
    } else {
      try {
        // console.log('Request:', error)
        const body = await error.json()
        console.log(body)
        if (body.message) {
          message = body.message
        } else if (body.erros) {
          message = body.erros[0].motivo
        } else {
          if (body.error)
            if (Array.isArray(body.error)) message = body.error[0].motivo
            else if (body.status && body.status === 404) message = `${body.error}\nPath: ${body.path}`
            else message = body.error
          else message = body.toString()
        }
      } catch (e) {
        // console.log(error)
        message = error.statusText
      }
    }
    return {
      type: ErrorTypes.INTERNAL_SERVER,
      message: message || 'Ocorreu um problema na requisição ao servidor.',
    } as InternalServerError
  }
}

/** Default authenticated response error adapter */
export class AuthResponseErrorAdapter extends ResponseErrorAdapter {
  public async mapApiModelToDomain(error: Response): Promise<ApiError> {
    // if (error instanceof Response && error.status === 403) {
    //   return {
    //     type: ErrorTypes.EXPIRED_SESSION,
    //     message: 'A sua sessão expirou.',
    //   }
    // }
    return super.mapApiModelToDomain(error)
  }
}

// export class ValidateTokenErrorAdapter extends ResponseErrorAdapter {
//   public mapApiModelToDomain = (error: Response): ApiError | undefined => {
//     if (error instanceof Response && error.status === 401) {
//       return {
//         type: ErrorTypes.INVALID_EMAIL_CODE,
//         message: 'Código de verificação inválido.',
//       }
//     }
//   }
// }
