import { Customer } from '@agiliza/api/domain'
import { UsuarioApiModel } from '@microcredito/client'

import { DomainAdapter } from './shared'

export class CustomerMapper implements DomainAdapter<UsuarioApiModel, Customer> {
  public mapApiModelToDomain = ({ usuarioCliente }: UsuarioApiModel): Customer => ({
    profilePicture: usuarioCliente?.fotoPerfil,
    cpfcnpj: usuarioCliente?.cpfcnpj || '',
    name: usuarioCliente?.nome || '',
    phone: usuarioCliente?.celular || '',
    ownerCPF: usuarioCliente?.cpfResponsavel,
    ownerName: usuarioCliente?.nomeResponsavel,
    address: usuarioCliente?.endereco
      ? {
          additionalInfo: usuarioCliente?.endereco.complemento,
          cep: usuarioCliente?.endereco.cep,
          city: usuarioCliente?.endereco.municipio,
          state: usuarioCliente?.endereco.estado,
          district: usuarioCliente?.endereco.bairro,
          number: usuarioCliente?.endereco.numero,
          street: usuarioCliente?.endereco.logradouro,
          id: usuarioCliente?.endereco.id,
        }
      : undefined,
    email: usuarioCliente?.email || '',
  })
}
