import { ClienteApiModels } from '@microcredito/client'

import { ApiAdapter } from './shared'

interface LoginParams {
  username: string
  password: string
}

export class LoginApiAdapter implements ApiAdapter<LoginParams, ClienteApiModels.LoginRequest> {
  public mapDomainToApiModel = (params: LoginParams): ClienteApiModels.LoginRequest => {
    const result: ClienteApiModels.LoginRequest = {
      loginRequestApiModel: {
        login: params.username,
        senha: params.password,
        agente: false,
      },
    }
    return result
  }
}
