import { InvolvedPerson } from '@agiliza/api/domain'

export const people = Array.from(Array(15).keys()).map<InvolvedPerson>((p) => {
  // const type = types[Math.ceil((Math.random() * 10) % types.length)]
  return {
    id: (p + 1).toString(),
    identification: {
      id: (p + 1).toString(),
      type: Math.ceil((Math.random() * 10) % 3).toString(),
      cpfcnpj: Math.ceil(Math.random() * 100000000000).toString(),
      gender: Math.floor((Math.random() * 10) % 2) ? '0' : '1',
      name: `Person ${p + 1}`,
      dataType: { framework: Math.ceil((Math.random() * 10) % 4).toString() },
    },
  }
})

export const frameworks = Array.from(Array(4).keys()).map<{ id: string; name: string }>((p) => ({
  id: (p + 1).toString(),
  name: `Enquadramento ${p + 1}`,
}))

export const genders = [
  { id: '0', name: 'Masculino' },
  { id: '1', name: 'Feminino' },
]
