export const creditLines = Array.from(Array(8).keys()).map((n, i) => ({
  id: i.toString(),
  name: `Line ${i + 1}`,
  amount: {
    min: 100,
    max: 9999,
  },
  paymentMonths: {
    min: 6,
    max: 36,
  },
  graceMonths: {
    min: 4,
    max: 24,
  },
  informations:
    'Donec sit amet ante rutrum, tincidunt ante quis, semper tortor. Quisque feugiat dictum dictum. Duis scelerisque erat sollicitudin egestas pretium. Vivamus eget magna eu dui vestibulum hendrerit nec vel mi. Mauris et urna blandit, porttitor dui at, semper justo. Vestibulum elit enim, finibus in porta vitae, faucibus non lacus. Ut feugiat magna ipsum, eu scelerisque risus dignissim semper. In condimentum tortor sit amet hendrerit tempus. Cras sed ex a libero euismod aliquet.',
}))

export interface CreditLineData {
  id: string
  amount: number
  graceMonths: number
  paymentMonths: number
  interestRate: number
  effectiveTotalCost: number
  openingCreditRate: number
}

export const creditLinesData: Record<string, CreditLineData> = Array.from(Array(8).keys()).reduce(
  (cLs, cL, i) => ({
    ...cLs,
    [i]: {
      id: i.toString(),
      amount: Math.random() * 1000,
      graceMonths: Math.ceil(Math.random() * 10),
      paymentMonths: Math.ceil(Math.random() * 10),
      interestRate: Math.ceil(Math.random() * 10),
      effectiveTotalCost: Number((Math.random() * 100).toFixed(2)),
      openingCreditRate: Math.ceil(Math.random() * 1000),
    },
  }),
  {}
)

export const destinations = [
  {
    id: '1',
    description: 'Ajustar o fluxo de caixa',
  },
  {
    id: '2',
    description: 'Compor caixa para possibilitar vendas a prazo',
  },
  {
    id: '3',
    description: 'Compor caixa para possibilitar vendas a prazo',
  },
  {
    id: '4',
    description: 'Comprar matérias primas',
  },
  {
    id: '5',
    description: 'Expandir seu negócio',
  },
  {
    id: '5',
    description: 'Fazer reformas necessárias na empresa',
  },
  {
    id: '6',
    description: 'Honrar acertos trabalhistas',
  },
]
