const express = require('express')
const path = require('path')
const server = express()

const channel = process.argv[2]
const port = process.argv[3] || 3000
const distPath = channel ? `dist/${channel}` : 'dist'

server.use(express.static(path.join(__dirname, distPath)))

server.get('*', (req, res) => {
  res.sendFile(path.join(__dirname, distPath, 'index.html'))
})

server.listen(Number(port), () => {
  console.log(`Listening at http://localhost:${port}/`)
})
