import cn from 'classnames'
import React from 'react'

import ItemWithIcon from '@agiliza/components/atoms/ItemWithIcon'
import List from '@material-ui/core/List'
import { ExitToApp, Visibility as VisibilityIcon } from '@material-ui/icons'
import withStyles from '@material-ui/styles/withStyles'

import { styles } from './styles'

import type { WithStyles } from '@material-ui/styles/withStyles'
import type { RouteComponentProps } from 'react-router-dom'
import type { Props as DrawerProps } from '@agiliza/components/molecules/Drawer'
interface ListItem {
  label: string
  path: string
  Icon: React.ComponentType
}

export const PATHS = {
  dashboard: '/dashboard',
  projects: '/projetos',
}

export const drawerListItems: ListItem[] = [{ label: 'Projetos', path: PATHS.projects, Icon: VisibilityIcon }]

type ExtendedTypes = RouteComponentProps & WithStyles<typeof styles>

interface Props extends ExtendedTypes {
  listItemClassName?: string
  toggleDrawer: () => void
  logout: DrawerProps['logout']
}

const isCurrentPath = (history: RouteComponentProps['history'], path: string) => {
  const result = history.location.pathname.replace(/(\/.*?)\/(.*?)$/g, '$1') === path
  return result
}

const DrawerItems = (props: Props) => {
  const { listItemClassName, history, classes, toggleDrawer, logout } = props
  const handleClick = (path: string) => () => {
    history.push(path)
    toggleDrawer()
  }
  const listItemComponent = (label: string, path: string, Icon: React.ComponentType) => (
    <ItemWithIcon
      key={path}
      label={label}
      className={cn(listItemClassName, { [classes.selected]: isCurrentPath(history, path) })}
      onClick={handleClick(path)}
    >
      <Icon />
    </ItemWithIcon>
  )

  return (
    <List className={classes.list}>
      {drawerListItems.map((item) => listItemComponent(item.label, item.path, item.Icon))}
      <ItemWithIcon label="Sair" className={listItemClassName} onClick={() => logout()}>
        <ExitToApp />
      </ItemWithIcon>
    </List>
  )
}

export default withStyles(styles)(DrawerItems)
