import { flexColumn } from '@agiliza/constants/styles'
import { makeStyles, Theme } from '@material-ui/core/styles'
import { createStyles } from '@material-ui/styles'

// eslint-disable-next-line
export const useStyles = makeStyles((theme: Theme) =>
  createStyles({
    title: {
      fontSize: '150%',
      fontWeight: 'bold',
      overflowWrap: 'normal',
    },
    formContainer: {
      height: '40%',
      textAlign: 'center',
      justifyContent: 'space-between',
      ...flexColumn,
    },
    container: {
      display: 'flex',
      height: '100vh',
      flexDirection: 'column',
      alignItems: 'center',
      justifyContent: 'center',
      textAlign: 'center',
    },
    logo: {
      position: 'absolute',
      opacity: 0.1,
      top: 0,
      left: 0,
      width: '100%',
      height: '100%',
      backgroundImage: `url(${'/images/logo.png'})`,
      backgroundSize: 'contain',
      backgroundRepeat: 'no-repeat',
      backgroundPosition: 'center',
    },
    form: {
      padding: 10,
      display: 'flex',
      flexDirection: 'column',
    },
    usernameTxtField: { marginBottom: 10 },
  })
)
