import 'core-js/stable'
import 'regenerator-runtime/runtime'
import './theme/index.global.css'

import ptBR from 'date-fns/locale/pt-BR'
import React from 'react'
import { render } from 'react-dom'
import { Provider } from 'react-redux'

import { browser, SUPPORTED_BROWSERS } from '@agiliza/constants/browser'
import DateFnsUtils from '@date-io/date-fns'
import { MuiThemeProvider } from '@material-ui/core/styles'
import { MuiPickersUtilsProvider } from '@material-ui/pickers'

import ErrorDialog from './components/molecules/ErrorDialog'
import { store } from './redux'
import { theme } from './theme'
import Views from './views'
import BrowserIncompatible from './views/BrowserIncompatible'

const isValidBrowser = browser.satisfies(SUPPORTED_BROWSERS)

const root = document.getElementById('root')

interface Props {}

const Adm = (props: Props) => {
  return (
    <Provider store={store}>
      <MuiThemeProvider theme={theme}>
        <MuiPickersUtilsProvider utils={DateFnsUtils} locale={ptBR}>
          <Views />
          <ErrorDialog />
        </MuiPickersUtilsProvider>
      </MuiThemeProvider>
    </Provider>
  )
}

if (isValidBrowser) {
  render(<Adm />, root)
} else {
  render(<BrowserIncompatible />, root)
}
