import { GetProjectContext, ProjectStatus } from '@agiliza/api/domain'
import { ProjetoSituacaoApiModel } from '@microcredito/client'

import { DomainAdapter } from '../shared'

export interface ContextoProjeto {
  situacoes: ProjetoSituacaoApiModel[]
}

export class ProjectContextStatusMapper implements DomainAdapter<ProjetoSituacaoApiModel, ProjectStatus> {
  public mapApiModelToDomain = (situacao: ProjetoSituacaoApiModel): ProjectStatus => ({
    id: situacao.codigo,
    description: situacao.descricao,
  })
}

export class GetProjectContextMapper implements DomainAdapter<ContextoProjeto, GetProjectContext['Output']> {
  private statusesMapper: ProjectContextStatusMapper
  constructor() {
    this.statusesMapper = new ProjectContextStatusMapper()
  }
  public mapApiModelToDomain = (input: ContextoProjeto): GetProjectContext['Output'] => ({
    statuses: input.situacoes.map(this.statusesMapper.mapApiModelToDomain),
  })
}
