import { BaseAddress, RG } from './index'

export interface SpousePersonalData {
  name?: string
  rg?: RG
  cpf?: string
  birthday?: Date | null
  userCRAS?: boolean
  participationPercentage?: string
  mothersName?: string
  fathersName?: string
  occupation?: string
  schooling?: string
  maritalStatus?: string
  dependents?: string
  marriageCertificate?: string
  primaryEmail?: string
  secundaryEmail?: string
  mobile?: string
  landline?: string
  workplace?: Workplace
}

export interface Workplace {
  admissionDate?: Date | null
  workplaceName?: string
  netIncome?: string
  role?: string
  phone?: string
  cnpj?: string
  address?: BaseAddress
  proof?: string
}

export interface FetchSpouseDataArgs {
  projectId: string
  personId: string
}

export interface UpdateSpouseDataArgs {
  projectId: string
  personId: string
  spouseData: SpousePersonalData
}

interface InputUpdateCDSpouseData {
  spouseData: SpousePersonalData
  projectId: string
  personId: string
}

export interface UpdateCDSpouseData {
  Input: InputUpdateCDSpouseData
  Output: SpousePersonalData
}
