import { PersonalData } from './personalData'

export interface InvolvedPerson {
  id: string
  identification: Identification
  personalData?: PersonalData
  sourceIncome?: SourceIncome
  address?: InvolvedPersonAddress
  home?: Home
  // spousePersonalData?: SpousePersonalData
  // vehicles?: Vehicle[]
  // references?: Reference[]
}

export interface Identification {
  id: string
  name: string
  cpfcnpj: string
  type: string
  gender: string
  account?: BanestesAccount
  dataType?: DataType
}

export interface BanestesAccount {
  number?: string
  cardPicture?: string
  agencyNumber?: string
}

export interface DataType {
  doesWithdrawal?: boolean
  participationPercentage?: string
  framework?: string
}

export type InvolvedPersonType = 'CUSTOMER' | 'PARTNER' | 'GUARANTOR'

interface InputAddCDIdentification {
  identification: Identification
  projectId: string
}

export interface AddCDIdentification {
  Input: InputAddCDIdentification
  Output: Identification
}
