import { Entity } from '@agiliza/utils/method'

export interface BDProductService extends Entity {
  description: string
  unit: string
  stock: PriceAmountValue
  monthlySales: PriceAmountValue
  variableCosts: PriceAmountValue
}

export interface PriceAmountValue {
  price: string
  amount: string
}

export interface AddBDProductServiceArgs {
  projectId: string
  productService: BDProductService
}
export interface UpdateBDProductServiceArgs {
  projectId: string
  productServiceId: string
  productService: BDProductService
}
export interface DeleteBDProductServiceArgs {
  projectId: string
  productServiceId: string
}

interface InputGetBDProductsServices {
  projectId: string
}

export interface GetBDProductsServices {
  Input: InputGetBDProductsServices
  Output: BDProductService[]
}

interface InputAddBDProductService {
  projectId: string
  productService: BDProductService
}

export interface AddBDProductService {
  Input: InputAddBDProductService
  Output: BDProductService[]
}

interface InputUpdateBDProductService {
  projectId: string
  productServiceId: string
  productService: BDProductService
}

export interface UpdateBDProductService {
  Input: InputUpdateBDProductService
  Output: BDProductService[]
}
