import { connect } from 'react-redux'
import { bindActionCreators, Dispatch } from 'redux'

import { Customer } from '@agiliza/api/domain'
import { StoreState } from '@agiliza/redux'
import * as session from '@agiliza/redux/session'
import * as uiSimulation from '@agiliza/redux/ui/simulation'
import * as ucProposalDataCD from '@agiliza/redux/useCases/proposalData/customerData'

export interface ConnectedProps {
  customer?: Customer
  simulationData: uiSimulation.State['data']
  createProposal: typeof ucProposalDataCD.actions.createProposal
}

type StateProps = Pick<ConnectedProps, 'customer' | 'simulationData'>
type DispatchProps = Pick<ConnectedProps, 'createProposal'>

const mapStateToProps = (state: StoreState): StateProps => ({
  customer: session.selectors.getCustomer(state.session),
  simulationData: uiSimulation.selectors.getData(state.ui.simulation),
})

const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
  bindActionCreators(
    {
      createProposal: ucProposalDataCD.actions.createProposal,
    },
    dispatch
  )

export const connected = connect(mapStateToProps, mapDispatchToProps)
