import React, { useMemo, useState } from 'react'
import { RouteComponentProps } from 'react-router'

import { SubProduct } from '@agiliza/api/domain'
import { extractNumbers } from '@agiliza/utils/method'
import { PATHS } from '@agiliza/views/Main/DrawerItems'
import { Button, Step, StepLabel, Stepper } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'
import {
  KeyboardArrowLeft as KeyboardArrowLeftIcon,
  KeyboardArrowRight as KeyboardArrowRightIcon
} from '@material-ui/icons'

import { connected, ConnectedProps } from './connect'
import CreditLinesInfo from './CreditLinesInfo'
import styles from './styles'
import UserForm from './UserForm'

type ExtendedProps = WithStyles<typeof styles> & RouteComponentProps & ConnectedProps

interface Props extends ExtendedProps {}

const Simulation = (props: Props) => {
  const { classes, customer, simulationData, ...routerProps } = props
  const { history } = routerProps
  // const theme = useTheme()
  const [activeStep, setActiveStep] = useState(0)
  // const [canGoForward, setCanGoForward] = useState(true)

  const [subproduct, setSubproduct] = useState<SubProduct | undefined>()

  const handleChangeSubproduct = (sp?: SubProduct) => {
    setSubproduct(sp)
  }

  const renderStep = (step: number) => {
    switch (step) {
      case 0:
        return <CreditLinesInfo subproduct={subproduct} onChangeSubproduct={handleChangeSubproduct} />
      case 1:
        return <UserForm />
    }
  }

  const handleNext = () => {
    if (activeStep === steps - 1) {
      if (simulationData && subproduct) {
        const { simulationCategoryId, amount, graceMonths, paymentMonths } = simulationData
        props.createProposal({
          categoryId: simulationCategoryId,
          creditValue: Number(extractNumbers(amount)),
          gracePeriodId: graceMonths,
          installmentsNumber: paymentMonths,
          subproductId: subproduct.id,
          onSuccess: () => history.push({ pathname: PATHS.proposalData, state: { subproductId: subproduct?.id } }),
        })
      }
    } else setActiveStep((prevActiveStep) => prevActiveStep + 1)
  }

  const handleBack = () => {
    setActiveStep((prevActiveStep) => prevActiveStep - 1)
  }

  const steps = useMemo(() => 2, [])

  const canGoForward = useMemo(() => {
    switch (activeStep) {
      case 0:
        return !!subproduct
      case 1:
        return !!customer
    }
  }, [activeStep, subproduct, customer])

  return (
    <div className={classes.pageContent}>
      <div className={classes.stepContentContainer}>{renderStep(activeStep)}</div>
      <div className={classes.stepperContainer}>
        <Button size="large" onClick={handleBack} disabled={activeStep === 0} className={classes.stepperBtn}>
          <KeyboardArrowLeftIcon />
          Anterior
        </Button>
        <Stepper activeStep={activeStep} className={classes.stepper}>
          <Step>
            <StepLabel>Informações linha de crédito</StepLabel>
          </Step>
          <Step>
            <StepLabel>Dados pessoais</StepLabel>
          </Step>
        </Stepper>
        <Button size="large" onClick={handleNext} disabled={!canGoForward} className={classes.stepperBtn}>
          {activeStep === steps - 1 ? (
            'Finalizar'
          ) : (
            <>
              Próximo
              <KeyboardArrowRightIcon />
            </>
          )}
        </Button>
        {/* <MobileStepper
          variant="dots"
          steps={steps}
          position="static"
          activeStep={activeStep}
          className={classes.stepper}
          nextButton={
            <Button size="small" onClick={handleNext} disabled={!canGoForward || activeStep === steps}>
              Próximo
              <KeyboardArrowRightIcon />
            </Button>
          }
          backButton={
            <Button size="small" onClick={handleBack} disabled={!canGoBackward || activeStep === 0}>
              <KeyboardArrowLeftIcon />
              Anterior
            </Button>
          }
        /> */}
      </div>
    </div>
  )
}

export default connected(withStyles(styles)(Simulation))
