import { connect } from 'react-redux'

import { SubProduct } from '@agiliza/api/domain'
import { StoreState } from '@agiliza/redux'
import * as entSimulation from '@agiliza/redux/entities/simulation/simulation'

export interface ConnectedProps {
  subproducts: SubProduct[]
}

type StateProps = Pick<ConnectedProps, 'subproducts'>
// type DispatchProps = Record<string, any>

const mapStateToProps = (state: StoreState): StateProps => ({
  subproducts: entSimulation.selectors.getSubproducts(state.entities.simulation.simulation),
})

// const mapDispatchToProps = (dispatch: Dispatch): DispatchProps => bindActionCreators({}, dispatch)

export const connected = connect(mapStateToProps)
