import { connect } from 'react-redux'
import { bindActionCreators, Dispatch } from 'redux'

import { StoreState } from '@agiliza/redux'

export interface ConnectedProps {
  reset: () => void
}

// type StateProps = Pick<ConnectedProps, 'customer' | 'simulationData'>
type DispatchProps = Pick<ConnectedProps, 'reset'>

const mapStateToProps = (state: StoreState) => ({})

const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
  bindActionCreators(
    {
      reset: () => ({ type: 'RESET_STORE' }),
    },
    dispatch
  )

export const connected = connect(mapStateToProps, mapDispatchToProps)
