import React from 'react'
import { RouteComponentProps } from 'react-router'

import { Button, Typography } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import { connected, ConnectedProps } from './connect'
import styles from './styles'

type ExtendedProps = WithStyles<typeof styles> & RouteComponentProps & ConnectedProps

interface Props extends ExtendedProps {}

const FinishSimulation = (props: Props) => {
  const { classes, history } = props
  const handleClick = () => {
    props.reset()
    history.push('/')
  }
  return (
    <div className={classes.pageContent}>
      <div className={classes.titleContainer}>
        <Typography variant="h4">Sua proposta foi submetida com sucesso!</Typography>
        <Typography variant="h6">Agora é só aguardar que entraremos em contato!</Typography>
      </div>
      <div style={{ flex: 1 }} />
      <Button onClick={handleClick} variant="contained" color="primary">
        VOLTAR PARA O INÍCIO
      </Button>
    </div>
  )
}

export default connected(withStyles(styles)(FinishSimulation))
