import sharedStyles from '@agiliza/views/shared-styles'
import { Theme } from '@material-ui/core/styles'
import { createStyles } from '@material-ui/styles'

// eslint-disable-next-line
export default (theme: Theme) =>
  createStyles({
    ...sharedStyles(theme),
    title: { marginBottom: theme.spacing(2) },
    link: { cursor: 'pointer' },
    breadcrumbsContainer: { margin: theme.spacing(2) },
    stepContentContainer: {
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'center',
      height: '92%',
      position: 'relative',
      overflowY: 'auto',
    },
    stepperContainer: { display: 'flex', alignItems: 'center', justifyContent: 'center', height: '8%' },
    stepper: { flexGrow: 1 },
    stepperBtn: { height: '100%' },
    pageTitle: { width: '100%', textAlign: 'center' },
    pageSubtitle: { width: '100%', textAlign: 'center' },
    contentContainer: { display: 'flex', flexDirection: 'column', alignItems: 'center', flexGrow: 1, overflowY: 'auto', padding: theme.spacing(2) },
    content: {
      display: 'flex',
      flexDirection: 'column',
      alignItems: 'center',
      width: '30%',
      height: '100%',
    },
  })
