import { connect } from 'react-redux'

import { ProposalDataContext } from '@agiliza/api/domain'
import { StoreState } from '@agiliza/redux'
import * as entProposalDataContext from '@agiliza/redux/entities/proposalData/context'
import * as ucProposalDataContext from '@agiliza/redux/useCases/proposalData/context'

export interface ConnectedProps {
  fetching: boolean
  context: ProposalDataContext
}

type StateProps = Pick<ConnectedProps, 'fetching' | 'context'>
// type DispatchProps = Pick<ConnectedProps, 'updateIndentification'>

const mapStateToProps = (state: StoreState): StateProps => ({
  fetching: ucProposalDataContext.selectors.isFetching(state.ui.login),
  context: entProposalDataContext.selectors.getContext(state.entities.proposalData.context),
})

// const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
//   bindActionCreators(
//     {
//     },
//     dispatch
//   )

export const connected = connect(mapStateToProps)
