import React from 'react'

import { BanestesAccount, DataType, ProposalDataContext } from '@agiliza/api/domain'
import AccountInputsPhoto from '@agiliza/components/templates/AccountInputsPhoto'
import { ActionType } from '@agiliza/utils/hooks/state'
import CPFCNPJField from '@agiliza/views/ProposalData/components/atoms/CPFCNPJField'
import { SelectField, SelectFieldProps } from '@curio/components'
import { FormControlLabel, Switch, TextField, TextFieldProps } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import { CDIdentificationState } from '../state'
import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  state: CDIdentificationState
  actions: ActionType<CDIdentificationState>
  context: ProposalDataContext
}

const Form = (props: Props) => {
  const { classes, state, actions, context } = props

  const { cpfcnpj, dataType, name, gender, hasAccount, account } = state

  const handleChangeText =
    (key: keyof CDIdentificationState): TextFieldProps['onChange'] =>
    (evt) => {
      actions.update({ [key]: evt.target.value })
    }
  const handleChangeSelect =
    (key: keyof CDIdentificationState): SelectFieldProps['onChange'] =>
    (vl) => {
      actions.update({ [key]: vl })
    }

  const handleChangeDataType =
    (key: keyof DataType): SelectFieldProps['onChange'] =>
    (vl) => {
      actions.update({ dataType: { [key]: vl } })
    }

  const handleChangeAccount =
    (type: keyof BanestesAccount): TextFieldProps['onChange'] =>
    (evt) => {
      actions.update({ account: { [type]: evt.target.value } })
    }

  const handleChangePhoto = (name: string) => {
    actions.update({ account: { cardPicture: name } })
  }

  const handleChangeValidState = (vldStt: boolean) => {}

  return (
    <form className={classes.form}>
      <SelectField
        id="framework-select-field"
        label="Enquadramento"
        value={dataType?.framework}
        onChange={handleChangeDataType('framework')}
        items={context.frameworks.map((fw) => ({ label: fw.description, value: fw.id }))}
        variant="outlined"
        shrink={false}
      />
      <CPFCNPJField value={cpfcnpj} onChange={handleChangeText('cpfcnpj')} onlyCPF />
      <TextField variant="outlined" label="Nome / Razão social" value={name || ''} onChange={handleChangeText('name')} />
      <SelectField
        id="gender-select-field"
        label="Sexo"
        value={gender}
        onChange={handleChangeSelect('gender')}
        items={context.genders.map((fw) => ({ label: fw.description, value: fw.id }))}
        variant="outlined"
        shrink={false}
      />
      <div className={classes.switchCardPhotoContainer}>
        <FormControlLabel
          label="Possui conta na entidade?"
          control={
            <Switch
              checked={hasAccount}
              onChange={(_, checked) => {
                actions.update({ hasAccount: checked })
              }}
              name="has-account"
              inputProps={{ 'aria-label': 'secondary checkbox' }}
            />
          }
        />
        {hasAccount ? (
          <AccountInputsPhoto
            values={{ ...account }}
            onChanges={{ account: handleChangeAccount, photo: handleChangePhoto, validState: handleChangeValidState }}
          />
        ) : null}
      </div>
    </form>
  )
}

export default withStyles(styles)(Form)
