import { connect } from 'react-redux'

import { AuthenticationContext, ProposalDataContext } from '@agiliza/api/domain'
import { StoreState } from '@agiliza/redux'
import * as entAuthentication from '@agiliza/redux/entities/authentication'
import * as entProposalDataContext from '@agiliza/redux/entities/proposalData/context'
import * as ucProposalDataContext from '@agiliza/redux/useCases/proposalData/context'

export interface ConnectedProps {
  fetching: boolean
  context: ProposalDataContext
  addressContext: AuthenticationContext
}

type StateProps = Pick<ConnectedProps, 'fetching' | 'context' | 'addressContext'>
// type DispatchProps = Pick<ConnectedProps, 'addIndentification'>

const mapStateToProps = (state: StoreState): StateProps => ({
  fetching: ucProposalDataContext.selectors.isFetching(state.ui.login),
  context: entProposalDataContext.selectors.getContext(state.entities.proposalData.context),
  addressContext: entAuthentication.selectors.getContextEntities(state.entities.authentication),
})

// const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
//   bindActionCreators(
//     {
//     },
//     dispatch
//   )

export const connected = connect(mapStateToProps)
