import { file } from '@agiliza/__mocks__/files'
import { IPAddress } from '@agiliza/api/domain'

type ExtendedState = IPAddress

export interface CDAddressState extends ExtendedState {}

export const initialState: CDAddressState =
  process.env.NODE_ENV === 'development'
    ? { id: '', proof: file, cep: '29100100', city: '16', complement: 'TEST', district: 'TEST', number: '123', state: '1', street: 'TEST' }
    : {
        id: '',
        proof: '',
        cep: '',
        city: '',
        complement: '',
        district: '',
        number: '',
        state: '',
        street: '',
      }
