import { connect } from 'react-redux'

import { BDProductService, ProposalDataContext } from '@agiliza/api/domain'
import { StoreState } from '@agiliza/redux'
import * as entProposalDataContext from '@agiliza/redux/entities/proposalData/context'
import * as entProposalData from '@agiliza/redux/entities/proposalData/proposal'

export interface ConnectedProps {
  context: ProposalDataContext
  productsServices: BDProductService[]
}

type StateProps = Pick<ConnectedProps, 'context' | 'productsServices'>
// type DispatchProps = Pick<ConnectedProps, 'addIndentification'>

const mapStateToProps = (state: StoreState): StateProps => ({
  context: entProposalDataContext.selectors.getContext(state.entities.proposalData.context),
  productsServices: entProposalData.selectors.getProductsServices(state.entities.proposalData.proposal),
})

// const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
//   bindActionCreators(
//     {
//     },
//     dispatch
//   )

export const connected = connect(mapStateToProps)
