import { connect } from 'react-redux'

import { ProposalDataContext } from '@agiliza/api/domain'
import { StoreState } from '@agiliza/redux'
import * as entProposalDataContext from '@agiliza/redux/entities/proposalData/context'

export interface ConnectedProps {
  context: ProposalDataContext
}

type StateProps = Pick<ConnectedProps, 'context'>
// type DispatchProps = Pick<ConnectedProps, 'addIndentification'>

const mapStateToProps = (state: StoreState): StateProps => ({
  context: entProposalDataContext.selectors.getContext(state.entities.proposalData.context),
})

// const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
//   bindActionCreators(
//     {
//     },
//     dispatch
//   )

export const connected = connect(mapStateToProps)
